/* ==================================================================
   Copyright:   Travellers Tales (UK)
   File:        SphereGeom.h
   Author:      Chris Halliday
   Date:        1st Aug 2005
   Format:      Generic C++
   Description: SphereGeom : A Sphere shaped collision geometry
	
   $Id: GhkSimplex.inl,v 1.3 2006-09-25 16:22:22 challiday Exp $
   $Log: not supported by cvs2svn $
   Revision 1.2.2.1  2006/09/20 12:31:30  challiday
   Removed PAIRLIST again
   Added GetColliders in AABB
   Lots of robustness owrk on convex queries.
   Changed collider to store RigidBody* rather than Geom*

   Revision 1.2  2006/08/22 16:13:50  challiday
   Merged Branch

   Revision 1.1.2.2  2006/08/14 13:31:43  challiday
   Carrage return at the end of each file to make the Ps3 compile.

   Revision 1.1.2.1  2006/08/14 10:59:34  challiday
   Removed Pair List (+50k)
   Improved Add/Remove performance
   Fixed broadphase AABB cast bug
   Re-written Ghk simplex and pen depth solver.
   Terrain decal projection
   Bouncy stack bug fix (gas station in transformers)
   capsule ray cast fix
   compound ray cast fix
   improved compound efficiency (single collider)
   replaced sets with arrays.
   fixed capsule-terrain bug
   streamlined the collision system structure.

===================================================================== */

#ifndef SIMPLEXINL
#define SIMPLEXINL

#include "nu2api.h"
#include "../Toolkit/Quaternion.h"

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline GhkSimplex::GhkSimplex() : ClosestPoint( VuVec_Up ), NumPoints(0), IdA(-1), IdB(-1)
{	
	Simplex[0] = 0;
	Simplex[1] = 1;
	Simplex[2] = 2;
	Simplex[3] = 3;
}

/*
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline GhkSimplex::GhkSimplex( const VuVec &AB ) : ClosestPoint(AB), NumPoints(0), IdA(-1), IdB(-1)
{	
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline GhkSimplex::GhkSimplex( const ConvexGeom &A, const ConvexGeom &B ) : NumPoints(0), IdA(-1), IdB(-1)
{
	ClosestPoint = A.GetTransform()[3] - B.GetTransform()[3];
}
*/
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void GhkSimplex::SetSimplexCache( SimplexCache &Cache , const ConvexGeom &GeomA, const ConvexGeom &GeomB )
{
	NumPoints = 0;
	IdA = Cache.IdA;
	IdB = Cache.IdB;
	ClosestPoint.LoadAsFloat3( &Cache.ClosestPoint.x );
	
	Simplex[0] = 0;
	Simplex[1] = 1;
	Simplex[2] = 2;
	Simplex[3] = 3;

	return;

	/*
	
	if (Cache.NumPoints == 0)
	{
		//NuMtx A( GeomA.GetTransform() );
		//NuMtx B( GeomB.GetTransform() );
		//ClosestPoint = A.GetT() - B.GetT();
		ClosestPoint=NuVec3::Get010();
	}
	else
		ClosestPoint = Cache.ClosestPoint;

	Simplex[0] = 0;
	Simplex[1] = 1;
	Simplex[2] = 2;
	Simplex[3] = 3;

	return;

	*/

	//NuMtx A( GeomA.GetTransform() );
	//NuMtx B( GeomB.GetTransform() );

	//
	//
	//
	//NumPoints = Cache.NumPoints;
	////NumPoints = 0;
	//	
	//for (int i=0; i<NumPoints; i++)
	//{
	//	pBuff[i] = Cache.pBuff[i] * A;
	//	qBuff[i] = Cache.qBuff[i] * B;
	//	wBuff[i] = pBuff[i]-qBuff[i];	
	//}	

	
	
	/*
	const VuMtx &A = GeomA.GetTransform();
	const VuMtx &B = GeomB.GetTransform();

	NumPoints = Cache.NumPoints;
	ClosestPoint = Cache.ClosestPoint;
	for (int i=0; i<NumPoints; i++)
	{
		//pBuff[i] = Cache.pBuff[i];
		//qBuff[i] = Cache.qBuff[i];
		VuVecMtxMul( &pBuff[i], &Cache.pBuff[i], &A );
		VuVecMtxMul( &qBuff[i], &Cache.qBuff[i], &B );		
		wBuff[i] = pBuff[i]-qBuff[i];	
	}	

	IdA = Cache.IdA;
	IdB = Cache.IdB;

	if (NumPoints == 0)
		ClosestPoint = GeomA.GetTransform()[3] - GeomB.GetTransform()[3];
	*/

}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void GhkSimplex::GetSimplexCache( SimplexCache &Cache, const ConvexGeom &GeomA, const ConvexGeom &GeomB )
{
	Cache.IdA = IdA;
	Cache.IdB = IdB;
	ClosestPoint.StoreAsFloat3( &Cache.ClosestPoint.x );

	/*
	Cache.mNumPoints = NumPoints;	
	for (int i=0 ;i<NumPoints; i++)
	{
		int RealIndex = Simplex[i];
		Cache.mIndexP[i] = pIndex[RealIndex];
		Cache.mIndexQ[i] = qIndex[RealIndex];
	}
	*/
	//Cache.ClosestPoint = ClosestPoint;

	return;

	//NuMtx A( GeomA.GetTransform() );
	//NuMtx B( GeomB.GetTransform() );	
	//
	//
	//for (int i=0; i<NumPoints; i++)
	//{
	//	Cache.pBuff[i] = pBuff[i].MulInvOrtho34( A );
	//	Cache.qBuff[i] = qBuff[i].MulInvOrtho34( B );
	//}

	

	/*
	const VuMtx &A = GeomA.GetTransform();
	const VuMtx &B = GeomB.GetTransform();

	Cache.NumPoints = NumPoints;
	Cache.ClosestPoint = ClosestPoint;
	for (int i=0; i<NumPoints; i++)
	{
		//Cache.pBuff[i] = pBuff[i];
		//Cache.qBuff[i] = qBuff[i];
		VuVecMtxMulInv( &Cache.pBuff[i], &pBuff[i], &A );
		VuVecMtxMulInv( &Cache.qBuff[i], &qBuff[i], &B );	
	}

	Cache.IdA = IdA;
	Cache.IdB = IdB;
	*/
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void GhkSimplex::ResetAll()
{
	NumPoints = 0;
	IdA = -1;
	IdB = -1;
	ClosestPoint = VuVec_Up;
	Simplex[0] = 0;
	Simplex[1] = 1;
	Simplex[2] = 2;
	Simplex[3] = 3;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void GhkSimplex::ResetIds()
{
	IdA = -1;
	IdB = -1;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void GhkSimplex::ResetSimplex()
{
	NumPoints = 0;
	//Simplex = {0,1,2,3};
	Simplex[0] = 0;
	Simplex[1] = 1;
	Simplex[2] = 2;
	Simplex[3] = 3;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
bool GhkSimplex::IsFull()    
{ 
	return NumPoints == 4; 
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
bool GhkSimplex::IsNotFull() 
{ 
	return NumPoints <  4; 
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
NuFloat GhkSimplex::GetSqrDistance()
{
	return ClosestPoint.LengthSqr();		
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
NuVec3 GhkSimplex::GetClosestPoint()
{
	return ClosestPoint;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
int GhkSimplex::GetSimplex( VuVec PBuf[], VuVec QBuf[], VuVec WBuf[])
{
	for (int i=0; i<NumPoints; i++)
	{
		PBuf[i] = pBuff[ Simplex[i] ].AsVuVec();
		QBuf[i] = qBuff[ Simplex[i] ].AsVuVec();
		WBuf[i] = wBuff[ Simplex[i] ].AsVuVec();
	}
	return NumPoints;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void GhkSimplex::GetVertIds( int VertIdsA[3], int VertIdsB[3] )
{
	NuAssert( NumPoints < 4, "Can't return verts ids for simplex that contains the origin");
	for (int i=0; i<NumPoints; i++)
	{
		int RealIndex = Simplex[i];
		VertIdsA[i] = pIndex[ RealIndex ];
		VertIdsB[i] = qIndex[ RealIndex ];
	}

	for ( int i=NumPoints; i<3; i++)
	{
		VertIdsA[i]=-1;
		VertIdsB[i]=-1;
	}
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void GhkSimplex::SetVertex( int Index, const NuVec3 &p, const NuVec3 &q, const NuVec3 &w , int pId, int qId )
{
	int RealIndex = Simplex[Index];
	wBuff[RealIndex] = w;
	pBuff[RealIndex] = p;
	qBuff[RealIndex] = q;	
	pIndex[ RealIndex ] = pId;
	qIndex[ RealIndex ] = qId;
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void GhkSimplex::SetBarry( int Index, const NuFloat &Barry )
{
	int RealIndex = Simplex[Index];
	wBuff[ RealIndex ].SetPadS( Barry );
}


///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
inline void GhkSimplex::MoveVertex( int SourceIndex, int TargetIndex )
{	
	int Temp = Simplex[ TargetIndex ];
	Simplex[ TargetIndex ] = Simplex[ SourceIndex ];
	Simplex[ SourceIndex ] = Temp;

	//pBuff[ TargetIndex ] = pBuff[ SourceIndex ];
	//qBuff[ TargetIndex ] = qBuff[ SourceIndex ];
	//wBuff[ TargetIndex ] = wBuff[ SourceIndex ];	
}



void GhkSimplex::SetSimplex( int A )
{
	NumPoints = 1;
	MoveVertex( A, 0 );
}

void GhkSimplex::SetSimplex( int A, int B )
{
	NumPoints = 2;
	MoveVertex( A, 0 );
	MoveVertex( B, 1 );	
}

void GhkSimplex::SetSimplex( int A, int B, int C )
{
	NumPoints = 3;
	MoveVertex( A, 0 );
	MoveVertex( B, 1 );
	MoveVertex( C, 2 );
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void GhkSimplex::AddVertex( const NuVec3 &p, const NuVec3 &q, const NuVec3 &w, int pId, int qId )
{	
	if ( NumPoints == 0 )
	{
		CreatePoint( p, q, w, pId, qId );		
	}
	else if (NumPoints == 1)
	{
		CreateLineSeg( p, q, w, pId, qId );	
	}
	else if (NumPoints == 2 )
	{
		CreateTriangle( p, q, w, pId,qId );		
	}
	else 
	{
		CreateTetrahedron( p, q, w, pId, qId );		
	}
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
bool GhkSimplex::ContainsPoint( const NuVec3 &w ) 
{
	static const NuFloat Small( 0.0001f );

	//const float Small = 0.0001f;
	for (int i=0; i<NumPoints; i++)
		if ((wBuff[ Simplex[i] ] - w).LengthSqr() <= Small)
			return true;
	
	return false;
}

#endif
